% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{chamorro_premuzic}
\alias{chamorro_premuzic}
\title{Chamorro-Premuzic, et al. (2008) data}
\format{
A tibble with 430 rows and 12 variables.
}
\source{
\href{https://www.discovr.rocks/csv/chamorro_premuzic.csv}{www.discovr.rocks/csv/chamorro_premuzic.csv}
}
\usage{
chamorro_premuzic
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
There is some evidence that students tend to pick courses of lecturers they perceive to be enthusastic and good communicators.
In a fascinating study, Tomas Chamorro-Premuzic and his colleagues (Chamorro-Premuzic, Furnham, Christopher, Garwood, & Martin, 2008)
tested the hypothesis that students tend to like lecturers who are like themselves. The authors measured students' own personalities
using a very well-established measure (the NEO-FFI) which measures five fundamental personality traits: neuroticism, extroversion,
openness to experience, agreeableness and conscientiousness. Students also completed a questionnaire in which they were given descriptions
(e.g., 'warm: friendly, warm, sociable, cheerful, affectionate, outgoing') and asked to rate how much they wanted to see this in a lecturer
from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer).
The characteristics were the same as those measured by the NEO-FFI. As such, the authors had a measure of how much a student had each of the
five core personality characteristics, but also a measure of how much they wanted to see those same characteristics in their lecturer.
These are the data from that study. The data contains the following variables:
\itemize{
\item \strong{age}: participant age (years)
\item \strong{sex}: participant's biological sex
\item \strong{stu_neurotic}: Student neuroticism score on the NEO-FFI
\item \strong{stu_extro}: Student extroversion score on the NEO-FFI
\item \strong{stu_open}: Student openness to experience score on the NEO-FFI
\item \strong{stu_agree}: Student agreeableness  score on the NEO-FFI
\item \strong{stu_consc}: Student conscientiousness score on the NEO-FFI
\item \strong{lec_neurotic}: Student rating of how much they wanted the characteristic of neuroticism in their lecturers from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer)
\item \strong{lec_extro}: Student rating of how much they wanted the characteristic of extroversion in their lecturers from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer)
\item \strong{lec_open}: Student rating of how much they wanted the characteristic of openness to experience in their lecturers from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer)
\item \strong{lec_agree}: Student rating of how much they wanted the characteristic of agreeableness in their lecturers from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer)
\item \strong{lec_consc}: Student rating of how much they wanted the characteristic of conscientiousness in their lecturers from -5 (I don't want this characteristic at all) through 0 (the characteristic is not important) to +5 (I really want this characteristic in my lecturer)
}
}
\references{
\itemize{
\item Chamorro-Premuzic, T., Furnham, A., Christopher, A. N., Garwood, J., & Neil Martin, G. (2008). Birds of a feather: Students' preferences for lecturers' personalities as predicted by their own personality and learning approaches. \emph{Personality and Individual Differences}, 44(4), 965–976. \doi{10.1016/j.paid.2007.10.032}
}
}
\keyword{datasets}
