% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{boxplot_epoch}
\alias{boxplot_epoch}
\title{Plot interactive boxplots of EEG amplitude on epoch level}
\usage{
boxplot_epoch(
  data,
  amplitude = "signal",
  epoch = NULL,
  time_lim,
  title_label = NULL,
  use_latex = TRUE
)
}
\arguments{
\item{data}{A data frame or a database table with EEG dataset. Required columns: \code{epoch}, \code{time} and the column with EEG amplitude named as in \code{amplitude} parameter.}

\item{amplitude}{A character specifying the name of the column from input data with an EEG amplitude values. Default is \code{"signal"}.}

\item{epoch}{A vector with numbers of epochs to plot. If missing, boxplots are drawn for all avaliable epochs in \code{data}.}

\item{time_lim}{A numeric vector with time range to plot.}

\item{title_label}{A character string specifying the title of the plot. Defaults to \code{NULL} for plot without title.}

\item{use_latex}{A logical value indicating whether to use LaTeX formatting for the y-axis title. The default is \code{TRUE}.}
}
\value{
A \code{plotly} object with boxplots of EEG amplitude for individual epochs.
}
\description{
Function for plotting interactive boxplots of EEG amplitude in individual epochs within the chosen time interval. The function assumes data from a single subject and a single sensor.
The interactive \code{plotly} output enables to easily determine the epoch number from which outliers come and also allows to easily edit the image layout.
}
\details{
The input data frame or database table must contain at least following columns:
\code{epoch} - a column with epoch numbers,
\code{time} - a column with time point numbers,
and a column with measured EEG signal values (or their averages) called as in \code{amplitude}.
}
\examples{
# Interactive boxplots of signal from channel E34 for subject 1 (health control)
# in time points 10:20
epochdata |>
pick_data(subject_rg = 1, sensor_rg = "E34") |>
boxplot_epoch(amplitude = "signal", time_lim = c(10:20),
title_label = "Subject 1, channel E34")

}
\seealso{
\code{\link{boxplot_subject}}
}
