% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classifiers_estimators.R
\name{Koutparams}
\alias{Koutparams}
\title{Koutrouvelis parameter estimation of image data}
\usage{
Koutparams(data)
}
\arguments{
\item{data}{matrix or data frame with color intensities of red, green and
blue for an image.}
}
\value{
a data frame with columns alpha, beta, gamma, delta and rows red,
  green and blue.
}
\description{
In data, there are three columns and each column corresponds to the color
intensity of one channel: red, green and blue correspondingly. The four
parameters: alpha, beta, gamma and delta, of the stable distribution is
estimated for each of these channels using the Koutrouvelis regressions-type
technique.
}
\examples{
library(deforestable)

Forestdir <- system.file('extdata/Forest/', package = "deforestable")
test_image <- read_data('_6_33_.jpeg', dir = Forestdir)

pars <- Koutparams(test_image)

pars

}
