% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2faststructure.r
\name{gl2faststructure}
\alias{gl2faststructure}
\title{Converts a genlight object into faststructure format (to run faststructure
 elsewhere)}
\usage{
gl2faststructure(
  x,
  outfile = "gl.str",
  outpath = NULL,
  probar = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file (including extension)
[default "gl.str"].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{probar}{Switch to show/hide progress bar [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
Recodes in the quite specific faststructure format (e.g first six columns
need to be there, but are ignored...check faststructure documentation
 (if you find any :-( )))
The script writes out the a file in faststructure format.
}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
