% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.subsample.ind.r
\name{gl.subsample.ind}
\alias{gl.subsample.ind}
\title{Subsample individuals from a genlight object}
\usage{
gl.subsample.ind(
  x,
  n = NULL,
  replace = TRUE,
  by.pop = TRUE,
  error.check = TRUE,
  mono.rm = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{n}{Number of individuals to include in the subsample [default NULL]}

\item{replace}{If TRUE, sampling is with replacement [default TRUE]}

\item{by.pop}{If FALSE, ignore population settings when subsampling; if TRUE, subsample
each population to n individuals [default TRUE].}

\item{error.check}{If TRUE, will undertake error checks on input paramaters [default TRUE]}

\item{mono.rm}{If TRUE and error.check is TRUE, monomorphic loci arising from the deletion of individuals
will be filtered from the resultant genlight object [default FALSE]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
Returns the subsampled genlight object
}
\description{
A function to subsample individuals at random in a genlight object
with and without replacement.
}
\details{
Retain a subset of individuals at random, with or without replacement.
If subsampling globally, n must be less than or equal to nInd(x). If subsampling
by population, then n must be less than the minimum sample size for any population.

Set error.check = FALSE for speedy execution in simulations
}
\examples{
gl <- gl.subsample.ind(testset.gl, n=30, by.pop=FALSE, replace=TRUE)
gl <- gl.subsample.ind(platypus.gl, n=10, by.pop=TRUE, replace=TRUE)
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{data manipulation}
