% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_hasResults.R
\name{f.hasResults}
\alias{f.hasResults}
\title{Calculate if a study's results are available}
\usage{
f.hasResults(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and new column `.hasResults` (logical).
}
\description{
Trial concept calculated: Calculates if results have been recorded in the
register, as structured data, reports or publications, for example.
Requires loading results-related information for EUCTR.
}
\examples{
# fields needed
f.hasResults()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.hasResults",
  con = dbc)
trialsDf

}
