% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csdm_specs.R
\name{csdm_csa}
\alias{csdm_csa}
\title{Specification: Cross-sectional averages (CSA)}
\usage{
csdm_csa(
  vars = "_all",
  lags = 0,
  scope = c("estimation", "global", "cluster"),
  cluster = NULL
)
}
\arguments{
\item{vars}{Character. One of "_all", "_none", or a character vector of variable names.}

\item{lags}{Integer. Either a scalar integer >= 0 applied to all CSA variables,
or a named integer vector giving per-variable maximum lags.}

\item{scope}{Character vector. One or more of c("estimation","global","cluster").}

\item{cluster}{Reserved for future use.}
}
\value{
A spec object (list) used by csdm().
}
\description{
Specification: Cross-sectional averages (CSA)
}
\examples{
# Cross-sectional averages (CSA) configuration for DCCE
csa <- csdm_csa(
  vars = c("log_rgdpo", "log_hc", "log_ck", "log_ngd"),
  lags = 3
)
csa
}
