% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_data.R, R/Data-methods.R
\name{h_plot_data_dataordinal}
\alias{h_plot_data_dataordinal}
\alias{plot,Data,missing-method}
\alias{plot-Data}
\alias{plot,DataOrdinal,missing-method}
\title{Helper Function for the Plot Method of the Data and DataOrdinal Classes}
\usage{
h_plot_data_dataordinal(
  x,
  blind = FALSE,
  legend = TRUE,
  tox_labels = c(Yes = "red", No = "black"),
  tox_shapes = c(Yes = 17L, No = 16L),
  mark_backfill = FALSE,
  ...
)

\S4method{plot}{Data,missing}(
  x,
  y,
  blind = FALSE,
  legend = TRUE,
  include_backfill = TRUE,
  mark_backfill = FALSE,
  mark_response = FALSE,
  ...,
  text_size_markings = 9,
  point_cex_markings = 1.1
)

\S4method{plot}{DataOrdinal,missing}(
  x,
  y,
  blind = FALSE,
  legend = TRUE,
  tox_labels = NULL,
  tox_shapes = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{DataOrdinal})\cr object we want to plot.}

\item{blind}{(\code{flag})\cr indicates whether to blind the data.
If \code{TRUE}, then placebo subjects are reported at the same level
as the active dose level in the corresponding cohort,
and DLTs are always assigned to the first subjects in a cohort.}

\item{legend}{(\code{flag})\cr whether the legend should be added.}

\item{tox_labels}{(\verb{named list of character})\cr the labels of the toxicity
categories.}

\item{tox_shapes}{(\verb{names list of integers})\cr the symbols used to identify
the toxicity categories.}

\item{mark_backfill}{(\code{flag})\cr whether to mark backfilled patients with empty shape.}

\item{...}{not used.}

\item{y}{(\code{missing})\cr missing object, for compatibility with the generic
function.}

\item{include_backfill}{(\code{flag})\cr whether to include backfilled patients.}

\item{mark_response}{(\code{flag})\cr whether to mark patients with response with rectangle.}

\item{text_size_markings}{(\code{number})\cr text size for the markings legend.}

\item{point_cex_markings}{(\code{number})\cr point size multiplier for the markings legend.}
}
\value{
The \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2}} object.

The \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2}} object.

The \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A method that creates a plot for \code{\link{Data}}  and \code{\link{DataOrdinal}} objects.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A method that creates a plot for \code{\link{Data}} object.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that creates a plot for \code{\link{DataOrdinal}} object.
}
\note{
The default values of \code{tox_shapes} and \code{tox_labels} result in DLTs
being displayed as red triangles and other responses as black circles.

With more than 9 toxicity categories, toxicity symbols must be
specified manually.\cr With more than 5 toxicity categories, toxicity labels
must be specified manually.
}
\examples{
# Create some data of class 'Data'.
my_data <- Data(
  x = c(0.001, 0.1, 0.1, 0.5, 0.001, 3, 3, 0.001, 10, 10, 10),
  y = c(0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0),
  cohort = c(1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 4),
  doseGrid = c(0.001, 0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2)),
  placeb = TRUE
)

# Plot the data.
plot(my_data)

# We can also mark backfill patients and response outcomes.
my_data@backfilled <- c(
  FALSE,
  FALSE,
  FALSE,
  FALSE,
  TRUE,
  TRUE,
  TRUE,
  FALSE,
  FALSE,
  FALSE,
  FALSE
)
my_data@response <- as.integer(c(
  NA,
  NA,
  1,
  NA,
  NA,
  0,
  1,
  NA,
  1,
  0,
  0
))
plot(
  my_data,
  mark_backfill = TRUE,
  mark_response = TRUE
)
data <- DataOrdinal(
  x = c(10, 20, 30, 40, 50, 50, 50, 60, 60, 60),
  y = as.integer(c(0, 0, 0, 0, 0, 1, 0, 0, 1, 2)),
  ID = 1L:10L,
  cohort = as.integer(c(1:4, 5, 5, 5, 6, 6, 6)),
  doseGrid = c(seq(from = 10, to = 100, by = 10)),
  yCategories = c("No tox" = 0L, "Sub-tox AE" = 1L, "DLT" = 2L),
  placebo = FALSE
)

plot(data)
}
