% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_probability_range}
\alias{check_probability_range}
\alias{assert_probability_range}
\alias{test_probability_range}
\alias{expect_probability_range}
\title{Check if an argument is a probability range}
\usage{
check_probability_range(x, bounds_closed = TRUE)

assert_probability_range(
  x,
  bounds_closed = TRUE,
  .var.name = checkmate::vname(x),
  add = NULL
)

test_probability_range(x, bounds_closed = TRUE)

expect_probability_range(
  x,
  bounds_closed = TRUE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{(\code{number})\cr an interval to check.}

\item{bounds_closed}{(\code{logical})\cr should bounds be closed? This can be a
scalar or vector of length two. If it is a scalar, then its value applies
equally to lower bound \eqn{0} and upper bound \eqn{1}. If this is a vector
with two flags, the first flag corresponds to the lower bound \eqn{0}
only, and the second to the upper bound \eqn{1} only.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
\code{TRUE} if successful, otherwise a string with the error message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Check if a given numerical interval represents a probability range, that is
a sub-interval of (0, 1) interval, that can optionally be closed at any side.
}
\examples{
x <- c(0, 0.2)
check_probability_range(x)
check_probability_range(rev(x))
check_probability_range(x, bounds_closed = FALSE)
check_probability_range(x, bounds_closed = c(FALSE, TRUE))
}
\seealso{
\code{\link{assertions}} for more details.
}
