% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rules.R
\name{h_next_best_mg_ci}
\alias{h_next_best_mg_ci}
\title{Credibility Intervals for Max Gain and Target Doses at \code{nextBest-NextBestMaxGain} Method.}
\usage{
h_next_best_mg_ci(dose_target, dose_mg, prob_target, placebo, model, model_eff)
}
\arguments{
\item{dose_target}{(\code{number})\cr target dose estimate.}

\item{dose_mg}{(\code{number})\cr the dose corresponding to the maximum gain.}

\item{prob_target}{(\code{proportion})\cr target DLT probability.}

\item{placebo}{(\code{flag})\cr if \code{TRUE} the first dose level in the dose grid used
is considered as placebo. This is needed to adjust the max gain dose using
efficacy constant value. If the \code{placebo} was used, then the \code{model_eff@const}
is added to \code{dose_mg}.}

\item{model}{(\code{ModelTox})\cr the DLT model.}

\item{model_eff}{(\code{Effloglog})\cr the efficacy model.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function for \code{\link[=nextBest-NextBestMaxGain]{nextBest-NextBestMaxGain()}} method. It computes a
95\% credibility intervals for given target dose and max gain dose.
It also returns a ratio of upper and lower bounds of the interval.
}
\references{
\insertRef{YeungWhiteheadReignerBeyerDiackJaki2015}{crmPack}
}
