% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_is_positive_definite}
\alias{h_is_positive_definite}
\title{Testing Matrix for Positive Definiteness}
\usage{
h_is_positive_definite(x, size = 2, tol = 1e-06)
}
\arguments{
\item{x}{(\code{matrix})\cr a matrix to be checked.}

\item{size}{(\code{integer})\cr a size of the square matrix \code{x} to be checked
against for.}

\item{tol}{(\code{number})\cr a given tolerance number used to check whether
an eigenvalue is positive or not. An eigenvalue is considered
as positive if and only if it is greater than the \code{tol}.}
}
\value{
\code{TRUE} if a given matrix is a positive-definite, \code{FALSE} otherwise.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This helper function checks whether a given numerical matrix \code{x} is a
positive-definite square matrix of a given size, without any missing
values. This function is used to test if a given matrix is a covariance
matrix, since every symmetric positive semi-definite matrix is a covariance
matrix.
}
\details{
The positive definiteness test implemented in this function
is based on the following characterization valid for real matrices:
\verb{A symmetric matrix is positive-definite if and only if all of its eigenvalues are positive.} In this function an eigenvalue is considered
as positive if and only if it is greater than the \code{tol}.
}
