% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{gain}
\alias{gain}
\alias{gain,numeric,ModelTox,Samples,ModelEff,Samples-method}
\alias{gain-ModelTox-ModelEff}
\alias{gain,numeric,ModelTox,missing,Effloglog,missing-method}
\alias{gain-ModelTox-Effloglog-noSamples}
\title{Compute Gain Values based on Pseudo DLE and a Pseudo Efficacy Models and
Using Optional Samples.}
\usage{
gain(dose, model_dle, samples_dle, model_eff, samples_eff, ...)

\S4method{gain}{numeric,ModelTox,Samples,ModelEff,Samples}(dose, model_dle, samples_dle, model_eff, samples_eff, ...)

\S4method{gain}{numeric,ModelTox,missing,Effloglog,missing}(dose, model_dle, samples_dle, model_eff, samples_eff, ...)
}
\arguments{
\item{dose}{(\code{number} or \code{numeric})\cr the dose which is targeted.
The following recycling rule applies when samples are not missing: vectors
of size 1 will be recycled to the size of the sample. Otherwise, \code{dose}
must have the same size as the sample.}

\item{model_dle}{(\code{ModelTox})\cr pseudo DLE (dose-limiting events)/toxicity
model.}

\item{samples_dle}{(\code{Samples})\cr the samples of model's
parameters that will be used to compute toxicity probabilities. Can also be
missing for some models.}

\item{model_eff}{(\code{ModelEff})\cr the efficacy model with pseudo data prior.}

\item{samples_eff}{(\code{Samples})\cr samples of model's parameters that will be
used to compute expected efficacy values. Can also be missing for some
models.}

\item{...}{not used.}
}
\value{
The gain values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This function computes the gain values for a given dose level,
pseudo DLE and Efficacy models as well as a given DLE and Efficacy samples.
}
\section{Functions}{
\itemize{
\item \code{gain(
  dose = numeric,
  model_dle = ModelTox,
  samples_dle = Samples,
  model_eff = ModelEff,
  samples_eff = Samples
)}: 

\item \code{gain(
  dose = numeric,
  model_dle = ModelTox,
  samples_dle = missing,
  model_eff = Effloglog,
  samples_eff = missing
)}: Compute the gain value for a given dose level, pseudo DLE
and Efficacy models without DLE and the Efficacy samples.

}}
\examples{
# Obtain the gain value for a given dose, a pseudo DLE and efficacy models
# as well as DLE and efficacy samples.
emptydata <- DataDual(doseGrid = seq(25, 300, 25), placebo = FALSE)
mcmc_opts <- McmcOptions(burnin = 100, step = 2, samples = 200)

# DLE model and samples.
model_dle <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = emptydata
)

samples_dle <- mcmc(emptydata, model_dle, mcmc_opts)

# Efficacy model (Effloglog) and samples.
model_effloglog <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = emptydata
)

samples_effloglog <- mcmc(emptydata, model_effloglog, mcmc_opts)

# Gain values for dose level 75 and Effloglog efficacy model.
gain(
  dose = 75,
  model_dle = model_dle,
  samples_dle = samples_dle,
  model_eff = model_effloglog,
  samples_eff = samples_effloglog
)

# Efficacy model (EffFlexi) and samples.
model_effflexi <- EffFlexi(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  sigma2W = c(a = 0.1, b = 0.1),
  sigma2betaW = c(a = 20, b = 50),
  rw1 = FALSE,
  data = emptydata
)

samples_effflexi <- mcmc(emptydata, model_effflexi, mcmc_opts)

# Gain values for dose level 75 and EffFlexi efficacy model.
gain(
  dose = 75,
  model_dle = model_dle,
  samples_dle = samples_dle,
  model_eff = model_effflexi,
  samples_eff = samples_effflexi
)
# Obtain the gain value for a given dose, a pseudo DLE and efficacy models
# without DLE and efficacy samples.
emptydata <- DataDual(doseGrid = seq(25, 300, 25), placebo = FALSE)
data <- Data(doseGrid = seq(25, 300, 25), placebo = FALSE)
mcmc_opts <- McmcOptions(burnin = 100, step = 2, samples = 200)

# DLE model and samples.
model_dle <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = data
)

# Efficacy model and samples.
model_eff <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = emptydata
)

# Gain value for dose level 75.
gain(
  dose = 75,
  model_dle = model_dle,
  model_eff = model_eff
)
}
