% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{ModelTox-class}
\alias{ModelTox-class}
\alias{.ModelTox}
\alias{ModelTox}
\alias{.DefaultModelTox}
\title{\code{ModelTox}}
\usage{
.DefaultModelTox()
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{ModelTox}} is the parent class for DLE (dose-limiting events) models using
pseudo data prior. It is dedicated for DLE models or toxicity models that
have their prior specified in the form of pseudo data (as if there is some
data before the trial starts).

The \code{data} must obey the convention of the \code{\link{Data}} class. This refers to any
observed DLE responses (\code{y} in \code{\link{Data}}), the dose levels (\code{x} in \code{\link{Data}})
at which these responses are observed, all dose levels considered in the
study (\code{doseGrid} in \code{\link{Data}}), and finally other specifications in \code{\link{Data}}
class that can be used to generate prior or posterior modal estimates or
samples estimates for model parameter(s).
If no responses are observed, at least \code{doseGrid} has to be specified
in \code{data} for which prior modal estimates or samples can be obtained for
model parameters based on the specified pseudo data.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{Data})\cr observed data that is used to obtain model parameters
estimates or samples (see details above).}
}}

\note{
Typically, end users will not use the \code{.DefaultModelTox()} function.
}
\seealso{
\code{\link{ModelEff}}.
}
