test_that("museum gaffe can be analyzed", {
  gaffe <- museum_lookup("covfefe")
  analysis <- analyze_gaffe(gaffe$gaffe, gaffe$original)

  expect_type(analysis, "list")
  expect_true(analysis$distance > 0)
})

test_that("covfefy transforms words using phonetic patterns", {
  expect_equal(covfefy("coverage"), "covfefe")
  expect_equal(covfefy("tropical"), "tropbibi")
})

test_that("full pipeline: generate and detect", {
  # Generate a keyboard typo
  set.seed(42)
  original <- "testing"
  typo <- adjacent_key_typo(original)

  # Detect the typo type
  detection <- detect_typo_type(typo, original)
  expect_true("keyboard" %in% detection$possible_types)
})

test_that("museum + corrupt integration", {
  gaffe <- museum_lookup("hamberders")

  # We can corrupt the original further
  set.seed(123)
  more_corrupt <- corrupt_text(gaffe$original, type = "keyboard")
  expect_type(more_corrupt, "character")
})

test_that("phonetic and keyboard engines work together", {
  # Get phonetic similarity
  phon_dist <- phonetic_distance("covfefe", "coverage")
  expect_true(is.numeric(phon_dist))

  # Check keyboard distance for individual chars
  kb_dist <- qwerty_distance("c", "v")
  expect_true(kb_dist > 0)
})
