# tests/testthat/test-corrupt.R

test_that("corrupt_text applies single corruption", {
  set.seed(42)
  result <- corrupt_text("hello world", type = "keyboard")
  expect_type(result, "character")
  expect_false(result == "hello world")
})

test_that("corrupt_text with random type", {
  set.seed(123)
  result <- corrupt_text("testing corruption", type = "random")
  expect_type(result, "character")
})

test_that("corrupt_text truncates", {
  result <- corrupt_text("despite the constant negative press coverage",
                         type = "truncate",
                         position = 6)
  expect_true(nchar(result) < nchar("despite the constant negative press coverage"))
})

test_that("corrupt_text double letter", {
  result <- corrupt_text("stolen", type = "double")
  # Should have a doubled letter somewhere
  expect_true(grepl("(.)\\1", result))
})

test_that("garble_sentence corrupts randomly", {
  set.seed(456)
  result <- garble_sentence("This is a test sentence", corruption_rate = 0.5)
  expect_type(result, "character")
  expect_false(result == "This is a test sentence")
})
