% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_join.R
\name{augment.matching_result}
\alias{augment.matching_result}
\title{Augment Matching Results with Original Data (broom-style)}
\usage{
\method{augment}{matching_result}(x, left, right, ...)
}
\arguments{
\item{x}{A matching_result object}

\item{left}{The original left dataset}

\item{right}{The original right dataset}

\item{...}{Additional arguments passed to \code{join_matched()}}
}
\value{
A tibble with matched pairs and original data (see \code{join_matched()})
}
\description{
S3 method for augmenting matching results following the broom package
conventions. This is a thin wrapper around \code{join_matched()} with
sensible defaults for quick exploration.
}
\details{
This method follows the \code{augment()} convention from the broom package,
making it easy to integrate couplr into tidymodels workflows. It's
equivalent to calling \code{join_matched()} with default parameters.

If the broom package is not loaded, you can use \code{couplr::augment()}
to access this function.
}
\examples{
left <- data.frame(
  id = 1:5,
  treatment = 1,
  age = c(25, 30, 35, 40, 45)
)

right <- data.frame(
  id = 6:10,
  treatment = 0,
  age = c(24, 29, 36, 41, 44)
)

result <- match_couples(left, right, vars = "age")
couplr::augment(result, left, right)

}
