% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsurveys-dir.R
\name{contactsurveys_dir}
\alias{contactsurveys_dir}
\title{Directory for persistent storage of contact surveys}
\usage{
contactsurveys_dir()
}
\value{
the active \code{contactsurveys} directory.
}
\description{
Returns a platform-specific directory for persistent storage of downloaded
survey files, powered by \code{\link[tools:userdir]{tools::R_user_dir()}}. You can override this by
setting the environment variable \code{CONTACTSURVEYS_HOME}.
}
\details{
By default, \code{\link[=download_survey]{download_survey()}} and \code{\link[=list_surveys]{list_surveys()}} use \code{\link[=tempdir]{tempdir()}} so
files do not persist across R sessions. To enable persistent caching, pass
\code{contactsurveys_dir()} as the \code{directory} argument, e.g.
\code{download_survey(survey, directory = contactsurveys_dir())}.
}
\examples{

contactsurveys_dir()

## Override with an environment variable:
Sys.setenv(CONTACTSURVEYS_HOME = tempdir())
contactsurveys_dir()
## Unset
Sys.unsetenv("CONTACTSURVEYS_HOME")

}
