% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{creating-filters}
\alias{creating-filters}
\alias{def_filter}
\alias{new_filter}
\title{Define custom filter.}
\usage{
def_filter(
  type,
  id = .gen_id(),
  name = id,
  input_param = NULL,
  filter_data,
  get_stats,
  plot_data,
  get_params,
  get_data,
  get_defaults
)

new_filter(
  filter_type,
  source_type,
  input_param = "value",
  extra_params = "",
  file
)
}
\arguments{
\item{type}{Filter type.}

\item{id}{Filter id.}

\item{name}{Filter name.}

\item{input_param}{Name of the parameter taking filtering value.}

\item{filter_data}{Function of `data_object` parameter defining filtering logic on Source data object.}

\item{get_stats}{Function of `data_object` and `name` parameters
defining what and how data statistics should be calculated.}

\item{plot_data}{Function of `data_object` parameter defining how filter data should be plotted.}

\item{get_params}{Function of `name` parameter returning
filter parameters (if names is skipped all the parameters are returned).}

\item{get_data}{Function of `data_object` returning filter related data.}

\item{get_defaults}{Function of `data_object` and `cache_object` parameters
returning default `input_param` parameter value.}

\item{filter_type}{Type of new filter.}

\item{source_type}{Type of source for which filter should be defined.}

\item{extra_params}{Vector of extra parameters name that should be available for filter.}

\item{file}{File path where filter should be created.}
}
\value{
A list of filter specific values and methods (`def_filter`) or no value (`new_filter`).
}
\description{
Methods available for creating new filters easier.
}
\details{
`def_filter` designates list of parameters and methods required to define new type of filter.

`new_filter` creates a new file with new filter definition template.

See vignettes("custom-filters") to learn how to create a custom filter.
}
