## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  fig.align = "center",
  dev = "jpeg",
  dpi = 300,
  out.width = "75%",
  comment = "#>"
)
suppressPackageStartupMessages({
  library("codyna")
})

## ----eval = FALSE-------------------------------------------------------------
# library("codyna")

## -----------------------------------------------------------------------------
data("engagement", package = "codyna")

## ----patterns-----------------------------------------------------------------
discover_patterns(engagement, type = "ngram", len = 2:3)
discover_patterns(engagement, type = "gapped", gap = 1)
discover_patterns(engagement, type = "repeated", len = 2:3)

## ----custom_pattern-----------------------------------------------------------
discover_patterns(engagement, pattern = "Active->*")

## ----indices------------------------------------------------------------------
sequence_indices(engagement)

## ----example_ts---------------------------------------------------------------
set.seed(123)
ts_data <- stats::arima.sim(list(order = c(1, 1, 0), ar = 0.6), n = 200)

## ----ews----------------------------------------------------------------------
ews_roll <- detect_warnings(ts_data, method = "rolling")
ews_exp <- detect_warnings(ts_data, method = "expanding")

## ----ews_plots, fig.width=6, fig.height=7-------------------------------------
plot(ews_roll)
plot(ews_exp)

## ----regimes------------------------------------------------------------------
regimes <- detect_regimes(
  data = ts_data,
  method = "threshold",
  sensitivity = "medium"
)
regimes

## ----regimes_plot, fig.width=8, fig.height=5----------------------------------
plot(regimes)

