% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{antidepressants}
\alias{antidepressants}
\title{Antidepressant Data}
\format{
A tibble with 1140 rows and 4 variables:

\describe{
\item{\code{patient}}{Patient identifier}
\item{\code{condition}}{Experimental condition}
\item{\code{measurement}}{Indicator of measurement}
\item{\code{mom_di}}{Mind over Mood Depression inventory scores
(lower is better)
}
}
}
\usage{
antidepressants
}
\description{
A fictional dataset used to showcase group-based clinical significance
analyses and analyses with many participants.
}
\details{
In a fictional clinical trial, the effectiveness of a new antidepressant
should be examined and depressed patients were randomized to one of four
groups:
\itemize{
\item A wait list control group that did not receive a medication
\item An inactive placebo group, i.e., a group that received a placebo
(inert substance without proposed clinical effect) pill
\item An active placebo group, i.e., a group that received a placebo that evokes
side effects like mild nausea or a dry mouth
\item The antidepressant group, so the target medication of this trial that should
have a clinical impact on the patients' depressive symptoms
}

Suppose they underwent outpatient treatment, depressive symptoms were measured
before and after treatment with the Mind over Mood Depression Inventory
(MoM-DI) by Greenberger & Padesky (2015), and if a patient received a pill,
the clinician and the patient did not know, what type of medicaction they
consumed.

Further, the minimal important difference for an improvement as measured by
this instrument was agreed to be an 8 point decrease. A deterioration can be
assumed if instrument scores increased by 5 points.

The functional population (i.e., non-depressed individuals) can be expected to
have a mean score of M = 8 points with a standard deviation of SD = 7.
}
\references{
Greenberger, D., & Padesky, C. A. (2015). Mind over mood, second
edition (2nd ed.). New York, NY: Guilford Publications.
}
\keyword{datasets}
