% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_validate.R
\name{validate_cdisc}
\alias{validate_cdisc}
\title{Validate CDISC Compliance}
\usage{
validate_cdisc(df, domain = NULL, standard = NULL)
}
\arguments{
\item{df}{A data frame to validate.}

\item{domain}{Optional character string specifying the CDISC domain code
(e.g., "DM", "AE") or ADaM dataset name (e.g., "ADSL", "ADAE"). If NULL, auto-detected.}

\item{standard}{Optional character string: "SDTM" or "ADaM". If NULL, auto-detected.}
}
\value{
A data frame with columns:
\item{category}{Character: type of validation issue ("Missing Required Variable",
"Missing Expected Variable", "Type Mismatch", "Non-Standard Variable", "Variable Info")}
\item{variable}{Character: variable name}
\item{message}{Character: description of the issue}
\item{severity}{Character: "ERROR", "WARNING", or "INFO"}
}
\description{
Main validation entry point that checks whether a data frame conforms to CDISC standards.
If domain and standard are not provided, they are automatically detected via
\code{\link[=detect_cdisc_domain]{detect_cdisc_domain()}}. Dispatches to \code{\link[=validate_sdtm]{validate_sdtm()}} or \code{\link[=validate_adam]{validate_adam()}} as appropriate.
}
\examples{
\donttest{
# Auto-detect domain
dm <- data.frame(
  STUDYID = "STUDY001",
  USUBJID = "SUBJ001",
  DMSEQ = 1,
  RACE = "WHITE",
  stringsAsFactors = FALSE
)
results <- validate_cdisc(dm)
print(results)

# Validate with explicit domain specification
results <- validate_cdisc(dm, domain = "DM", standard = "SDTM")
}
}
