% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_report.R
\name{print_cdisc_validation}
\alias{print_cdisc_validation}
\title{Print CDISC Validation Results}
\usage{
print_cdisc_validation(validation_result)
}
\arguments{
\item{validation_result}{A data frame from \code{\link[=validate_cdisc]{validate_cdisc()}}.}
}
\value{
Invisibly returns the input (useful for piping).
}
\description{
Pretty-prints CDISC validation results to the console with a summary and grouped
output by category. Displays counts of errors, warnings, and info messages.
}
\details{
Output includes:
\itemize{
\item Summary counts of errors, warnings, and info messages
\item Issues grouped by category
\item Each issue displayed with its variable name and message
}
}
\examples{
\dontrun{
# Validate a dataset
dm <- data.frame(
  STUDYID = "STUDY001",
  USUBJID = c("SUBJ001", "SUBJ002"),
  DMSEQ = c(1, 1),
  RACE = c("WHITE", "BLACK OR AFRICAN AMERICAN")
)

validation_result <- validate_cdisc(dm, domain = "DM", standard = "SDTM")
print_cdisc_validation(validation_result)
}
}
