% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_climate_data.R
\name{get_station}
\alias{get_station}
\title{Find climate station or stations from a given place. This also
confirms if a given climate station ID is valid.}
\usage{
get_station(place)
}
\arguments{
\item{place}{Either a numeric station ID or a place name. Case
insensitive.}
}
\value{
Returns a tibble containing id, name, and location for all
valid stations corresponding to place. Or NA if none are found.
}
\description{
Find climate station or stations from a given place. This also
confirms if a given climate station ID is valid.
}
\examples{
get_station("squamish")
get_station("SqUaMiSh")
get_station(337)
}
