% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_cfb.R
\name{load_cfb_teams}
\alias{load_cfb_teams}
\title{Load CFB team info from the data repo}
\usage{
load_cfb_teams(fbs_only = TRUE)
}
\arguments{
\item{fbs_only}{if TRUE, returns only FBS teams, otherwise returns all teams in the dataset}
}
\value{
A tibble of team-level image URLs and hex color codes.
}
\description{
Loads team information including colors and logos - useful for plots!
This function wraps the \code{cfbd_team_info()} function sourced from the College Football Data API.
}
\examples{
\donttest{
  try(load_cfb_teams())
}

}
\seealso{
\code{\link[=cfbd_team_info]{cfbd_team_info()}}

Issues with this data should be filed here: \url{https://github.com/sportsdataverse/cfbfastR-data}

Other loaders: 
\code{\link{load_cfb_pbp}()},
\code{\link{load_cfb_rosters}()},
\code{\link{load_cfb_schedules}()},
\code{\link{update_cfb_db}()}
}
\concept{loaders}
