% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpc-run.R
\name{tpc_run}
\alias{tpc_run}
\title{Run the TPC Algorithm for Causal Discovery}
\usage{
tpc_run(
  data = NULL,
  knowledge = NULL,
  alpha = 0.05,
  test = reg_test,
  suff_stat = NULL,
  method = "stable.fast",
  na_method = "none",
  orientation_method = "conservative",
  directed_as_undirected = FALSE,
  varnames = NULL,
  num_cores = 1,
  ...
)
}
\arguments{
\item{data}{A data frame with the observed variables.}

\item{knowledge}{A \code{knowledge} object created with \code{knowledge()},
encoding tier assignments and optional forbidden/required edges. This is
the preferred way to provide temporal background knowledge.}

\item{alpha}{The alpha level used as the per-test significance
threshold for conditional independence testing.}

\item{test}{A conditional independence test. The default \code{reg_test}
uses a regression-based information-loss test. Another available option is
\code{cor_test} which tests for vanishing partial correlations. User-supplied
functions may also be used; see details for the required interface.}

\item{suff_stat}{A sufficient statistic. If supplied, it is passed directly
to the test and no statistics are computed from \code{data}. Its structure
depends on the chosen \code{test}.}

\item{method}{Skeleton construction method, one of \code{"stable"},
\code{"original"}, or \code{"stable.fast"} (default). See
\code{\link[pcalg:skeleton]{pcalg::skeleton()}} for details.}

\item{na_method}{Handling of missing values, one of \code{"none"} (default;
error on any \code{NA}), \code{"cc"} (complete-case analysis), or
\code{"twd"} (test-wise deletion).}

\item{orientation_method}{Conflict-handling method when orienting edges.
Currently only the conservative method is available.}

\item{directed_as_undirected}{Logical; if \code{TRUE}, treat any directed
edges in \code{knowledge} as undirected during skeleton learning. This
is due to the fact that \pkg{pcalg} does not allow directed edges in
\code{fixedEdges} or \code{fixedGaps}. Default is \code{FALSE}.}

\item{varnames}{Character vector of variable names. Only needed when
\code{data} is not supplied and all information is passed via
\code{suff_stat}.}

\item{num_cores}{Integer number of CPU cores to use for parallel skeleton learning.}

\item{...}{Additional arguments passed to
\code{\link[pcalg:skeleton]{pcalg::skeleton()}} during skeleton construction.}
}
\value{
A \code{Disco} object (a list with a \code{caugi} and a \code{knowledge} object).
}
\description{
Run a tier-aware variant of the PC algorithm that respects background
knowledge about a partial temporal order. Supply the temporal order via a
\code{knowledge} object.
}
\details{
Any independence test implemented in \pkg{pcalg} may be used; see
\code{\link[pcalg:pc]{pcalg::pc()}}. When \code{na_method = "twd"}, test-wise deletion is
performed: for \code{cor_test}, each pairwise correlation uses complete cases;
for \code{reg_test}, each conditional test performs its own deletion. If you
supply a user-defined \code{test}, you must also provide \code{suff_stat}.

Temporal or tiered knowledge enters in two places:
\itemize{
\item during skeleton estimation, candidate conditioning sets are pruned so
they do not contain variables that are strictly after both endpoints;
\item during orientation, any cross-tier edge is restricted to point
forward in time.
}
}
\examples{
# Load data
data(tpc_example)

# Build knowledge
kn <- knowledge(
  tpc_example,
  tier(
    child ~ tidyselect::starts_with("child"),
    youth ~ tidyselect::starts_with("youth"),
    old ~ tidyselect::starts_with("old")
  )
)

# Recommended route using disco
my_tpc <- tpc(engine = "causalDisco", test = "fisher_z", alpha = 0.05)

disco(tpc_example, my_tpc, knowledge = kn)

# or using my_tpc directly

my_tpc <- my_tpc |> set_knowledge(kn)
my_tpc(tpc_example)

# Using tpc_run() directly

tpc_run(tpc_example, knowledge = kn, alpha = 0.01)
}
