% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{recall}
\alias{recall}
\title{Recall}
\usage{
recall(truth, est, type = c("adj", "dir"))
}
\arguments{
\item{truth}{A \link[caugi:caugi]{caugi::caugi} object representing the truth graph.}

\item{est}{A \link[caugi:caugi]{caugi::caugi} object representing the estimated graph.}

\item{type}{Character string specifying the comparison type:
\itemize{
\item \code{"adj"}: adjacency comparison.
\item \code{"dir"}: orientation comparison conditional on shared adjacencies.
}}
}
\value{
A numeric in \verb{[0,1]}.
}
\description{
Computes recall from two PDAG \link[caugi:caugi]{caugi::caugi} objects.
It converts the \link[caugi:caugi]{caugi::caugi} objects to adjacency matrices and computes
recall as \code{TP/(TP + FN)}, where \code{TP} are truth positives and
\code{FN} are false negatives. If \code{TP + FN = 0}, \code{1} is returned.
Only supports \link[caugi:caugi]{caugi::caugi} objects with these edge types present \verb{-->}, \verb{<-->}, \verb{---} and no edge.
}
\examples{
cg1 <- caugi::caugi(A \%-->\% B + C)
cg2 <- caugi::caugi(B \%-->\% A + C)
recall(cg1, cg2, type = "adj")
recall(cg1, cg2, type = "dir")

}
\seealso{
Other metrics: 
\code{\link{confusion}()},
\code{\link{evaluate}()},
\code{\link{f1_score}()},
\code{\link{false_omission_rate}()},
\code{\link{fdr}()},
\code{\link{g1_score}()},
\code{\link{npv}()},
\code{\link{precision}()},
\code{\link{reexports}},
\code{\link{specificity}()}
}
\concept{metrics}
