% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{num_data_latent}
\alias{num_data_latent}
\title{Simulated Numerical Data with Latent Variable}
\format{
A data.frame with 1000 rows and 4 variables.
\describe{
\item{X1}{Structural equation: \eqn{X_1 := \sqrt{Z} + \epsilon_1} with \eqn{\epsilon_1 \sim \mathrm{Unif}[0, 2]}}
\item{X2}{Structural equation: \eqn{X_2 := 2 \cdot X_3 - \epsilon_2} with \eqn{\epsilon_2 \sim N(5, 1)}}
\item{X3}{Structural equation: \eqn{X_3 := \epsilon_3} with \eqn{\epsilon_3 \sim \mathrm{Unif}[5, 10]}}
\item{Z}{Structural equation: \eqn{Z := |\epsilon_4|} with \eqn{\epsilon_4 \sim N(10, 1)}}
\item{Y}{Structural equation: \eqn{Y := X_1^2 + X_2 - X_3 - Z + \epsilon_5} with \eqn{\epsilon_5 \sim N(10, 1)}}
}
}
\usage{
num_data_latent
}
\description{
A dataset similar to \code{num_data} but with the variable \code{Z} treated as a latent variable and thus omitted.
}
\details{
The R code used to generate this dataset is as follows:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{data(num_data)
num_data_latent <- num_data[, c("X1", "X2", "X3", "Y")]
}\if{html}{\out{</div>}}
}
\examples{
data(num_data_latent)
head(num_data_latent)

}
\seealso{
\link{num_data}
}
\concept{dataset}
\keyword{datasets}
