% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnlearn-search.R
\name{BnlearnSearch}
\alias{BnlearnSearch}
\title{R6 Interface to bnlearn Search Algorithms}
\value{
An R6 object with the methods documented below.
}
\description{
A wrapper that lets you drive \pkg{bnlearn} algorithms within the \pkg{causalDisco} framework.
For arguments to the test, score, and algorithm, see the \pkg{bnlearn} documentation.
}
\examples{
### bnlearn_search R6 class examples ###

# Generally, we do not recommend using the R6 classes directly, but rather
# use the disco() or any method function, for example pc(), instead.

# Load data
data(num_data)

# Recommended:
my_pc <- pc(engine = "bnlearn", test = "fisher_z", alpha = 0.05)
result <- my_pc(num_data)

# or
result <- disco(data = num_data, method = my_pc)

plot(result)

# Example with detailed settings:
my_pc2 <- pc(
  engine = "bnlearn",
  test = "mi_g",
  alpha = 0.01
)
disco(data = num_data, method = my_pc2)

# With knowledge

kn <- knowledge(
  num_data,
  starts_with("X") \%-->\% Y
)

disco(data = num_data, method = my_pc2, knowledge = kn)

# Using additional test args (bootstrap samples)

my_iamb <- iamb(
  engine = "bnlearn",
  test = "mc_zf",
  alpha = 0.05,
  B = 100
)

disco(data = num_data, method = my_iamb)

# Using R6 class:
s <- BnlearnSearch$new()

s$set_data(num_data)
s$set_test(method = "fisher_z", alpha = 0.05)
s$set_alg("pc")

g <- s$run_search()

plot(g)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{A \code{data.frame} holding the data set currently attached to the
search object. Can be set with \code{set_data()}.}

\item{\code{score}}{Character scalar naming the score function used in
\pkg{bnlearn}. Can be set with \code{$set_score()}. Kebab-case score names (as used in \pkg{bnlearn}, e.g.
\code{"pred-loglik"}) are also accepted and automatically translated to snake_case.
Recognised values are:

\strong{Continuous - Gaussian}
\itemize{
\item \code{"aic_g"}, \code{"bic_g"}, \code{"ebic_g"}, \code{"loglik_g"}, \code{"pred_loglik_g"} -
gaussian versions of the respective scores for discrete data.
\item \code{"bge"} - Gaussian posterior density.
\item \code{"nal_g"} - node-average log-likelihood.
\item \code{"pnal_g"} - penalised node-average log-likelihood.
}

\strong{Discrete – categorical}
\itemize{
\item \code{"aic"} - Akaike Information Criterion.
\item \code{"bdla"} - locally averaged BDE.
\item \code{"bde"} - Bayesian Dirichlet equivalent (uniform).
\item \code{"bds"} - Bayesian Dirichlet score.
\item \code{"bic"} - Bayesian Information Criterion.
\item \code{"ebic"} - Extended BIC.
\item \code{"fnml"} - factorised NML.
\item \code{"k2"} - K2 score.
\item \code{"loglik"} - log-likelihood.
\item \code{"mbde"} - modified BDE.
\item \code{"nal"} - node-average log-likelihood.
\item \code{"pnal"} - penalised node-average log-likelihood.
\item \code{"pred_loglik"} - predictive log-likelihood.
\item \code{"qnml"} - quotient NML.
}

\strong{Mixed Discrete/Gaussian}
\itemize{
\item \code{"aic_cg"}, \code{"bic_cg"}, \code{"ebic_cg"}, \code{"loglik_cg"}, \code{"nal_cg"},
\code{"pnal_cg"}, \code{"pred_loglik_cg"} - conditional Gaussian versions of the respective scores for
discrete data.
}}

\item{\code{test}}{Character scalar naming the conditional-independence test
passed to \pkg{bnlearn}. Can be set with \code{$set_score()}. Kebab-case test names
(as used in \pkg{bnlearn}, e.g. "mi-adf") are also accepted and automatically translated to snake_case.
Recognised values are:

\strong{Continuous - Gaussian}
\itemize{
\item \code{"cor"} – Pearson correlation
\item \code{"fisher_z"} / \code{"zf"} – Fisher Z test
\item \code{"mc_cor"} – Monte Carlo Pearson correlation
\item \code{"mc_mi_g"} – Monte Carlo mutual information (Gaussian)
\item \code{"mc_zf"} – Monte Carlo Fisher Z
\item \code{"mi_g"} – mutual information (Gaussian)
\item \code{"mi_g_sh"} – mutual information (Gaussian, shrinkage)
\item \code{"smc_cor"} – sequential Monte Carlo Pearson correlation
\item \code{"smc_mi_g"} – sequential Monte Carlo mutual information (Gaussian)
\item \code{"smc_zf"} – sequential Monte Carlo Fisher Z
}

\strong{Discrete – categorical}
\itemize{
\item \code{"mc_mi"} – Monte Carlo mutual information
\item \code{"mc_x2"} – Monte Carlo chi-squared
\item \code{"mi"} – mutual information
\item \code{"mi_adf"} – mutual information with adjusted d.f.
\item \code{"mi_sh"} – mutual information (shrinkage)
\item \code{"smc_mi"} – sequential Monte Carlo mutual information
\item \code{"smc_x2"} – sequential Monte Carlo chi-squared
\item \code{"sp_mi"} – semi-parametric mutual information
\item \code{"sp_x2"} – semi-parametric chi-squared
\item \code{"x2"} – chi-squared
\item \code{"x2_adf"} – chi-squared with adjusted d.f.
}

\strong{Discrete – ordered factors}
\itemize{
\item \code{"jt"} – Jonckheere–Terpstra
\item \code{"mc_jt"} – Monte Carlo Jonckheere–Terpstra
\item \code{"smc_jt"} – sequential Monte Carlo Jonckheere–Terpstra
}

\strong{Mixed Discrete/Gaussian}
\itemize{
\item \code{"mi_cg"} – mutual information (conditional Gaussian)
}

For Monte Carlo tests, set the number of permutations using the \code{B} argument.}

\item{\code{alg}}{Function generated by \code{$set_alg()} that runs a
structure-learning algorithm from \pkg{bnlearn}. Period.case alg names
(as used in \pkg{bnlearn}, e.g. "fast.iamb") are also accepted and automatically translated to snake_case.
Recognised values are:

\strong{Constraint-based}
\itemize{
\item \code{"fast_iamb"} – Fast-IAMB algorithm. See \code{\link[=fast_iamb]{fast_iamb()}} and the underlying \code{\link[bnlearn:constraint]{bnlearn::fast.iamb()}}.
\item \code{"gs"} – Grow-Shrink algorithm. See \code{\link[=gs]{gs()}} and the underlying \code{\link[bnlearn:constraint]{bnlearn::gs()}}.
\item \code{"iamb"} – Incremental Association Markov Blanket algorithm.
See \code{\link[=iamb]{iamb()}} and the underlying \code{\link[bnlearn:constraint]{bnlearn::iamb()}}.
\item \code{"iamb_fdr"} – IAMB with FDR control algorithm. See \code{\link[=iamb_fdr]{iamb_fdr()}} and the underlying
\code{\link[bnlearn:constraint]{bnlearn::iamb.fdr()}}.
\item \code{"inter_iamb"} – Interleaved-IAMB algorithm. See \code{\link[=inter_iamb]{inter_iamb()}} and the underlying
\code{\link[bnlearn:constraint]{bnlearn::inter.iamb()}}.
\item \code{"pc"} – PC-stable algorithm. See \code{\link[=pc]{pc()}} and the underlying
\code{\link[bnlearn:constraint]{bnlearn::pc.stable()}}.
}}

\item{\code{params}}{A list of extra tuning parameters stored by \code{set_params()}
and spliced into the learner call.}

\item{\code{knowledge}}{A list with elements \code{whitelist} and \code{blacklist}
containing prior-knowledge constraints added via \code{set_knowledge()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BnlearnSearch-new}{\code{BnlearnSearch$new()}}
\item \href{#method-BnlearnSearch-set_params}{\code{BnlearnSearch$set_params()}}
\item \href{#method-BnlearnSearch-set_data}{\code{BnlearnSearch$set_data()}}
\item \href{#method-BnlearnSearch-set_test}{\code{BnlearnSearch$set_test()}}
\item \href{#method-BnlearnSearch-set_score}{\code{BnlearnSearch$set_score()}}
\item \href{#method-BnlearnSearch-set_alg}{\code{BnlearnSearch$set_alg()}}
\item \href{#method-BnlearnSearch-set_knowledge}{\code{BnlearnSearch$set_knowledge()}}
\item \href{#method-BnlearnSearch-run_search}{\code{BnlearnSearch$run_search()}}
\item \href{#method-BnlearnSearch-clone}{\code{BnlearnSearch$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the \code{BnlearnSearch} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_params"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_params}{}}}
\subsection{Method \code{set_params()}}{
Set the parameters for the search algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_params(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{A parameter to set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_data"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_data}{}}}
\subsection{Method \code{set_data()}}{
Set the data for the search algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_data(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to use for the search.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_test"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_test}{}}}
\subsection{Method \code{set_test()}}{
Set the conditional-independence test to use in the search algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_test(method, alpha = 0.05)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Character naming the test to use.}

\item{\code{alpha}}{Significance level for the test.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_score"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_score}{}}}
\subsection{Method \code{set_score()}}{
Set the score function for the search algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_score(method)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Character naming the score function to use.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_alg"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_alg}{}}}
\subsection{Method \code{set_alg()}}{
Set the causal discovery algorithm to use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_alg(method, args = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Character naming the algorithm to use.}

\item{\code{args}}{A list of additional arguments to pass to the algorithm.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-set_knowledge"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-set_knowledge}{}}}
\subsection{Method \code{set_knowledge()}}{
Set the prior knowledge for the search algorithm using a \code{Knowledge} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$set_knowledge(knowledge_obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{knowledge_obj}}{A \code{Knowledge} object containing prior knowledge.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-run_search"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-run_search}{}}}
\subsection{Method \code{run_search()}}{
Run the search algorithm on the currently set data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$run_search(data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to use for the search.
If NULL, the currently set data will be used, i.e. \code{self$data}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BnlearnSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BnlearnSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BnlearnSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
