% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{spouses}
\alias{spouses}
\title{Get spouses (bidirected neighbors) of nodes in an ADMG}
\usage{
spouses(cg, nodes = NULL, index = NULL)
}
\arguments{
\item{cg}{A \code{caugi} object of class ADMG.}

\item{nodes}{A vector of node names.}

\item{index}{A vector of node indexes.}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get nodes connected via bidirected edges in an ADMG.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  A \%<->\% C,
  B \%<->\% C,
  class = "ADMG"
)
spouses(cg, "A") # "C"
spouses(cg, "C") # c("A", "B")

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
