% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\name{export-classes}
\alias{export-classes}
\title{Export Format Classes}
\description{
S7 classes for representing caugi graphs in various export formats.
These classes provide a common interface for serializing graphs to
different text formats like DOT, GraphML, JSON, etc.
}
\section{Base Class}{

\code{\link{caugi_export}} is the base class for all export formats. It provides:
\itemize{
\item \code{content} property: Character string containing the serialized graph
\item \code{format} property: Character string indicating the format type
\item Common methods: \code{print()}, \code{as.character()}, \code{knit_print()}
}
}

\section{Subclasses}{

\itemize{
\item \code{\link{caugi_dot}}: DOT format for Graphviz visualization
\item \code{\link{caugi_mermaid}}: Mermaid format for web-based visualization
}
}

\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
