% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metal_emissions.R
\name{metal_emissions}
\alias{metal_emissions}
\title{Metal emissions (UK govt schema; table-driven, with material_production)}
\usage{
metal_emissions(
  use = stats::setNames(numeric(), character()),
  waste = TRUE,
  material_production = "Primary material production",
  waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{use}{Named numeric vector of metal quantities in tonnes.
Canonical names supported: \code{aluminium}, \code{mixed_cans}, \code{scrap}, \code{steel_cans}.
Aliases accepted (case/punct/UK-US spelling-insensitive), e.g.:
\code{"Metal: aluminium cans and foil (excl. forming)"}, \code{aluminum_cans},
\code{aluminium_foil}, \code{mixed}, \code{scrap_metal}, etc.
Unknown names warn and are ignored.}

\item{waste}{Logical. If \code{TRUE}, waste tonnages are the same as \code{use}.
If \code{FALSE}, no waste is applied.}

\item{material_production}{Either a single string applied to all metals, or a
named vector per metal type. Accepted values (matched leniently):
\code{"Primary material production"}, \code{"Closed-loop source"}, \code{"Closed-loop"},
\code{"Open-loop"}, \code{"Combustion"}, \code{"Landfill"}.
Synonyms accepted: \code{"primary"}, \code{"closed loop"}, \code{"open loop"}, etc.
Unspecified metals default to \code{"Primary material production"}.}

\item{waste_disposal}{One of \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"},
\code{"Open-loop"}. Applied to all waste.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which numeric column in \code{uk_gov_data} to use: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when any nonzero \code{use}/waste needs a
factor absent in the table. If \code{FALSE}, treat missing factors as 0.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Computes embodied GHG emissions for metals using \code{uk_gov_data} rows with
Level 2 = "Metal". Material-use factors come from
\verb{Level 1 = "Material use", Column Text = material_production}. Waste factors
come from \verb{Level 1 = "Waste disposal", Column Text = waste_disposal}.
Factors are kg CO2e per tonne.
}
\examples{
# Primary for all; landfill; waste = use
metal_emissions(
  use = c(aluminium = 1.2, steel_cans = 0.4),
  material_production = "Primary material production",
  waste_disposal = "Landfill",
  waste = TRUE,
  units = "kg"
)

# Per-metal: aluminium closed-loop source, others primary; no waste; 2024 factors
metal_emissions(
  use = c(`Metal: aluminium cans and foil (excl. forming)` = 0.5, mixed_cans = 0.2),
  material_production = c(aluminium = "closed loop"),
  waste = FALSE,
  value_col = "value_2024",
  units = "tonnes"
)
}
