% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_parser.R
\name{phase_parser}
\alias{phase_parser}
\title{Parses a phase string}
\usage{
phase_parser(phase_string)
}
\arguments{
\item{phase_string}{A string specifying trials within a phase.}
}
\value{
A named list with:
\describe{
\item{trial_info:}{A trial-named list of lists.}
\item{general_info:}{General phase information.}
}
}
\description{
Parses a phase string
}
\note{
This function is meant for internal use only,
but we expose it so you can test your strings.
}
\examples{
# A silly (but valid) string
phase_parser("10#Rescorla>Wagner")

# An invalid string that needs trial repetitions for one of trials.
try(phase_parser("10#Rescorla/Wagner"))
}
\seealso{
\code{\link[=parse_design]{parse_design()}}
}
