% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_input_date_picker}
\alias{calcite_input_date_picker}
\title{Create a InputDatePicker component}
\usage{
calcite_input_date_picker(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a InputDatePicker component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   disabled \tab disabled \tab When \code{true}, interaction is prevented and the component is displayed with lower opacity. \tab boolean \tab TRUE \cr
   flipPlacements \tab NA \tab Specifies the component's fallback \code{calcite-date-picker} \code{placement} when it's initial or specified \code{placement} has insufficient space available. \tab Check API reference \tab FALSE \cr
   focusTrapDisabled \tab focus-trap-disabled \tab When \code{true}, prevents focus trapping. \tab boolean \tab TRUE \cr
   form \tab form \tab The \code{id} of the form that will be associated with the component.  When not set, the component will be associated with its ancestor form element, if any. \tab string \tab TRUE \cr
   headingLevel \tab heading-level \tab Specifies the heading level of the component's \code{heading} for proper document structure, without affecting visual styling. \tab 1 | 2 | 3 | 4 | 5 | 6 \tab TRUE \cr
   layout \tab layout \tab Defines the layout of the component. \tab "horizontal" | "vertical" \tab TRUE \cr
   max \tab max \tab When the component resides in a form, specifies the latest allowed date ("yyyy-mm-dd"). \tab string \tab TRUE \cr
   maxAsDate \tab NA \tab Specifies the latest allowed date as a full date object. \tab Date \tab FALSE \cr
   messageOverrides \tab NA \tab Use this property to override individual strings used by the component. \tab Check API reference \tab FALSE \cr
   min \tab min \tab When the component resides in a form, specifies the earliest allowed date ("yyyy-mm-dd"). \tab string \tab TRUE \cr
   minAsDate \tab NA \tab Specifies the earliest allowed date as a full date object. \tab Date \tab FALSE \cr
   monthStyle \tab month-style \tab Specifies the monthStyle used by the component. \tab "abbreviated" | "wide" \tab FALSE \cr
   name \tab name \tab Specifies the name of the component.  Required to pass the component's \code{value} on form submission. \tab string \tab TRUE \cr
   numberingSystem \tab numbering-system \tab Specifies the Unicode numeral system used by the component for localization. This property cannot be dynamically changed. \tab "arab" | "arabext" | "latn" \tab TRUE \cr
   open \tab open \tab When \code{true}, displays the \code{calcite-date-picker} component. \tab boolean \tab TRUE \cr
   overlayPositioning \tab overlay-positioning \tab Determines the type of positioning to use for the overlaid content.  Using \code{"absolute"} will work for most cases. The component will be positioned inside of overflowing parent containers and will affect the container's layout.  \code{"fixed"} should be used to escape an overflowing parent container, or when the reference element's \code{position} CSS property is \code{"fixed"}. \tab "absolute" | "fixed" \tab TRUE \cr
   placement \tab placement \tab Specifies the placement of the \code{calcite-date-picker} relative to the component. \tab "bottom" | "bottom-end" | "bottom-start" | "top" | "top-end" | "top-start" \tab TRUE \cr
   proximitySelectionDisabled \tab proximity-selection-disabled \tab When \code{true}, disables the default behavior on the third click of narrowing or extending the range. Instead starts a new range. \tab boolean \tab FALSE \cr
   range \tab range \tab When \code{true}, activates a range for the component. \tab boolean \tab TRUE \cr
   readOnly \tab read-only \tab When \code{true}, the component's value can be read, but controls are not accessible and the value cannot be modified. \tab boolean \tab TRUE \cr
   required \tab required \tab When \code{true} and the component resides in a form, the component must have a value in order for the form to submit. \tab boolean \tab TRUE \cr
   scale \tab scale \tab Specifies the size of the component. \tab "l" | "m" | "s" \tab TRUE \cr
   status \tab status \tab Specifies the status of the input field, which determines message and icons. \tab "idle" | "invalid" | "valid" \tab TRUE \cr
   validationIcon \tab validation-icon \tab Specifies the validation icon to display under the component. \tab boolean | string \tab TRUE \cr
   validationMessage \tab validation-message \tab Specifies the validation message to display under the component. \tab string \tab FALSE \cr
   validity \tab NA \tab The current validation state of the component. \tab Check API reference \tab FALSE \cr
   value \tab value \tab Selected date as a string in ISO format (\code{"yyyy-mm-dd"}). \tab Check API reference \tab FALSE \cr
   valueAsDate \tab NA \tab The component's value as a full date object. \tab Check API reference \tab FALSE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteInputDatePickerBeforeClose \tab Fires when the component is requested to be closed and before the closing transition begins. \cr
   calciteInputDatePickerBeforeOpen \tab Fires when the component is added to the DOM but not rendered, and before the opening transition begins. \cr
   calciteInputDatePickerChange \tab Fires when the component's \code{value} changes. \cr
   calciteInputDatePickerClose \tab Fires when the component is closed and animation is complete. \cr
   calciteInputDatePickerOpen \tab Fires when the component is open and animation is complete. \cr
}

}
}
\examples{
calcite_input_date_picker()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/input-date-picker/}{Official Documentation}
}
