% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_dip_bundestag.R
\name{dip_bundestag_vorgang_list}
\alias{dip_bundestag_vorgang_list}
\title{List DIP Vorgang entries}
\usage{
dip_bundestag_vorgang_list(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with DIP response metadata.
}
\description{
List DIP Vorgang entries
}
\details{
Returns metadata for DIP Vorgang entries. Requires an API key. Obtain a key
from https://dip.bundestag.de/über-dip/hilfe/api.

Configure authentication via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} or set the
\code{DIP_BUNDESTAG_API_KEY} environment variable directly.
}
\examples{
\dontrun{
# Recommended: use bunddev_auth_set
Sys.setenv(DIP_BUNDESTAG_API_KEY = "<api-key>")
bunddev_auth_set(
  "dip_bundestag",
  type = "api_key",
  env_var = "DIP_BUNDESTAG_API_KEY",
  scheme = "ApiKey"
)
dip_bundestag_vorgang_list()
}

}
\seealso{
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure authentication.
}
