% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_webcams}
\alias{autobahn_webcams}
\title{List Autobahn webcams}
\usage{
autobahn_webcams(road_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{road_id}{Road identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with webcams.
}
\description{
List Autobahn webcams
}
\details{
Returns webcam entries for a specific Autobahn road id.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
autobahn_webcams(roads$road_id[[1]], flatten = TRUE)
}
}
\seealso{
\code{\link[=autobahn_roads]{autobahn_roads()}} and \code{\link[=autobahn_webcam_details]{autobahn_webcam_details()}}.
}
