% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRvolatility}
\alias{summary.SDDRvolatility}
\title{Provides summary of verifying homoskedasticity}
\usage{
\method{summary}{SDDRvolatility}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRvolatility} obtained using the
\code{verify_volatility()} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the logarithm of Bayes factors of homoskedastic to
heteroskedastic posterior odds \code{"log(SDDR)"} for each structural shock, 
their numerical standard errors \code{"NSE"}, and the implied posterior 
probability of the homoskedasticity and heteroskedasticity hypothesis, 
\code{"Pr[homoskedasticity|data]"} and \code{"Pr[heteroskedasticity|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of structural shocks homoskedasticity.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 1, M = 2)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_volatility(posterior)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_msh$new(p = 1, M = 2) |>
  estimate(S = 10) |> 
  verify_volatility() |> 
  summary() -> sddr_summary

}
\seealso{
\code{\link{verify_volatility}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
