% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_get_record.R
\name{bs_get_record}
\alias{bs_get_record}
\title{Get an arbitrary record from a repo}
\usage{
bs_get_record(
  repo = NULL,
  collection = NULL,
  rkey = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{repo}{Character, length 1. The handle or DID of the repo.}

\item{collection}{Character, length 1. The NSID of the record collection.}

\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of upload blob information
}
\description{
Get an arbitrary record from a repo
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/getRecord.json}{repo/getRecord.json (2023-11-24)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-24)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_record('https://bsky.app/profile/bskyr.bsky.social/post/3kf2577exva2x')
\dontshow{\}) # examplesIf}
}
\concept{repo}
