% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EB.R
\name{EB}
\alias{EB}
\title{Empirical Bayes predictor for random effects}
\usage{
EB(model, y, X, Z = X, BS = TRUE)
}
\arguments{
\item{model}{An object of class \code{brokenstick}.}

\item{y}{A vector of new measurements for unit j, scaled in the same metric as the fitted model.}

\item{X}{A \code{nj * p} matrix with fixed effects for unit j, typically produced by \code{bs()}.}

\item{Z}{A \code{nj * q} matrix with random effects for unit j. The default sets \code{Z} equal to \code{X}.}

\item{BS}{A logical indicating whether broken stick estimates should be
returned (\code{BS = TRUE}) or the random effects (\code{BS = FALSE}).
The default is \code{TRUE}.}
}
\value{
A vector of length q containing the random effect or broken stick  estimates for unit j.
}
\description{
This function can estimate random effect for a given set of
model estimates and new user data. The unit may be
new to the model. The methods implements the
EB estimate (also known as BLUP)
as described in Skrondral and Rabe-Hasketh, 2009, p. 683.
This function can also provide the broken stick estimate for a given level,
the sum of the global (fixed) and individual (random) effects.
The current implementation does not provide prediction errors.
}
\references{
Skrondal, A., Rabe-Hesketh, S. (2009).
Prediction in multilevel generalized linear models.
J. R. Statist. Soc. A, 172, 3, 659-687.
}
\author{
Stef van Buuren 2023
}
