% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_shallow2atomic.R
\name{cast_shallow2atomic}
\alias{cast_shallow2atomic}
\alias{cast_shallow2atomic.default}
\title{Cast Shallow List to Atomic Object}
\usage{
cast_shallow2atomic(x, ...)

\method{cast_shallow2atomic}{default}(x, arrangement = 0L, padding = NA, comnames_from = 1L, ...)
}
\arguments{
\item{x}{a shallow (i.e. non-nested) list. \cr
The attributes of the objects inside the list will be ignored, except for \code{names}.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{arrangement}{see the \code{Details} and \code{Examples} sections.}

\item{padding}{an atomic scalar, and only relevant if \code{arrangement} is \code{1} or \code{-1}. \cr
This gives the padding value to use when padding is required. \cr
Padding is used to ensure every all slices of the same dimension in the output
have equal number of elements
(for example, all rows must have the same number of columns).}

\item{comnames_from}{an integer scalar or \code{NULL}, and only relevant if \code{arrangement} is \code{1} or \code{-1}. \cr
This gives which element of \code{x} to use for the communal names. \cr
If \code{NULL}, no communal names will be given. \cr
For example: \cr
If \code{x} is a 1d (or dimensionless) list,
\code{cast_shallow2atomic(x, 1, arrangement = 1)} will produce an atomic matrix. \cr
The column names of the matrix will be \code{names(x)}. \cr
The row names, however, will be taken from \code{names(x[[comnames_from]])},
provided that \code{x[[comnames_from]]} has the proper length. \cr
See also the \code{Examples} section.}
}
\value{
If \code{arrangement = 0L}: \cr
An atomic vector. \cr
\cr
If \code{arrangement = 1L}: \cr
An atomic array. \cr
\cr
If \code{arrangement = -1L}: \cr
An atomic array. \cr
\cr
The type of the result is determined from the highest \code{atomic} type of any of the list elements
(including elements of length zero). \cr
The hierarchy of \code{atomic} types is: \cr
raw < logical < integer < double < complex < character. \cr
List elements that are not \code{atomic} but language expressions,
like formulas,
will be coerced to type of \code{character}. \cr
\cr
}
\description{
\code{cast_shallow2atomic()} casts a shallow (i.e. non-nested) list to an atomic object. \cr
\cr
}
\details{
If \code{arrangement = 0L}, \cr
\code{cast_shallow2atomic()} works like \code{unlist()},
except that \code{cast_shallow2atomic()} guarantees an atomic vector result. \cr
\cr
If \code{arrangement = 1L}, \cr
\code{cast_shallow2atomic()} will produce an atomic array,
with the elements arranged such that the dimensions are \code{c(max(lengths(x)), dim(x))}. \cr
If \code{x} has no dimensions, \code{dim(x)} is replaced with \code{length(x)}, thus treating \code{x} as an 1d array. \cr
This will therefore always produce an atomic array with at least 2 dimensions. \cr
The \code{dimnames}, if possible to construct,
will be \code{c(names(x[[comnames_from]]), dimnames(x))}. \cr
\cr
If \code{arrangement = -1L}, \cr
\code{cast_shallow2atomic()} will produce an atomic array,
with the elements arranged such that the dimensions are \code{c(dim(x), max(lengths(x)))}. \cr
If \code{x} has no dimensions, \code{dim(x)} is replaced with \code{length(x)}, thus treating \code{x} as an 1d array. \cr
This will therefore always produce an atomic array with at least 2 dimensions. \cr
The \code{dimnames}, if possible to construct,
will be \code{c(dimnames(x), names(x[[comnames_from]]))}. \cr
\cr
In all cases, the result will be \code{atomic}. \cr
\cr
}
\section{Back transformation}{

From the casted atomic object, \cr
\code{out <- cast_shallow2atomic(x, ...)}, \cr
one can get an \emph{approximation} of the original shallow list back using just base 'R' functions. \cr
This section describes how to do so. \cr
\cr
\bold{\code{arrangement = 0L}} \cr
If \code{arrangement = 0L}, one can transform an atomic object \code{out} back to a shallow list using: \cr
\code{back <- as.list(out)} \cr
\code{names(back) <- names(out)} \cr
\cr

\bold{\code{arrangement = 1L}} \cr
If \code{arrangement = 1L}, one can transform an atomic object \code{out} back to a shallow list using: \cr
\code{asplit(out, seq(2, ndim(out)))} \cr
\cr

\bold{\code{arrangement = -1L}} \cr
If \code{arrangement = -1L}, one can transform an atomic object \code{out} back to a shallow list using: \cr
\code{asplit(out, seq(1, ndim(out) - 1L))} \cr
\cr
\cr
}

\examples{

# recursive vector ====
x <- list(
  setNames(1:11, letters[1:11]), 1:10, 1:9, 1:8, 1:7, 1:6, 1:5, 1:4, 1:3, 1:2, 1L, integer(0L)
)
names(x) <- month.abb
print(x)

cast_shallow2atomic(x, 0L)
cast_shallow2atomic(x, 1L, comnames_from = 1L)
cast_shallow2atomic(x, -1L, comnames_from = 1L)


# recursive matrix ====
x <- list(
  setNames(1:11, letters[1:11]), 1:10, 1:9, 1:8, 1:7, 1:6, 1:5, 1:4, 1:3, 1:2, 1L, integer(0L)
) |> rev()
dim(x) <- c(3, 4)
dimnames(x) <- list(month.abb[1:3], month.name[1:4])
print(x)

cast_shallow2atomic(x, 0L)
cast_shallow2atomic(x, 1L, comnames_from = length(x))
cast_shallow2atomic(x, -1L, comnames_from = length(x))

}
\seealso{
\link{broadcast_casting} \cr
}
