% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-auth.R
\name{read_databrickscfg}
\alias{read_databrickscfg}
\title{Reads Databricks CLI Config}
\usage{
read_databrickscfg(
  key = c("token", "host", "wsid", "client_id", "client_secret"),
  profile = NULL,
  error = TRUE
)
}
\arguments{
\item{key}{The value to fetch from profile. One of \code{token}, \code{host}, \code{wsid},
\code{client_id}, or \code{client_secret}}

\item{profile}{Character, the name of the profile to retrieve values}
}
\value{
named list of values associated with profile
}
\description{
Reads Databricks CLI Config
}
\details{
Reads \code{.databrickscfg} file and retrieves the values associated to
a given profile. Brickster searches for the config file in the user's home directory by default.
To see where this is you can run Sys.getenv("HOME") on unix-like operating systems,
or, Sys.getenv("USERPROFILE") on windows.
An alternate location will be used if the environment variable \code{DATABRICKS_CONFIG_FILE} is set.
}
\keyword{internal}
