% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_exchange_rate.R
\name{plot_exchange_rate}
\alias{plot_exchange_rate}
\title{Plot Brazilian exchange rate (USD/BRL)}
\usage{
plot_exchange_rate(data, language = "eng")
}
\arguments{
\item{data}{Tibble returned by \code{get_exchange_rate()}}

\item{language}{Language for titles and labels: "pt" (Portuguese) or "eng" (English).}
}
\value{
A \code{ggplot2} object showing the exchange rate over time.
}
\description{
Generates a time series plot of the USD/BRL exchange rate using data from \code{get_exchange_rate()}.
Shows the commercial exchange rate for US Dollar to Brazilian Real.
}
\examples{
\dontrun{
# Example 1: English version
exchange_data <- get_exchange_rate("2023-01-01", "2023-12-31")
exchange_plot <- plot_exchange_rate(exchange_data)
print(exchange_plot)

# Example 2: Portuguese version
dados_cambio <- get_exchange_rate("2023-01-01", "2023-12-31", language = "pt")
grafico_cambio <- plot_exchange_rate(dados_cambio, language = "pt")
print(grafico_cambio)
}
}
