% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_api.R
\name{tournament}
\alias{tournament}
\title{Create an empty live tournament pipeline}
\usage{
tournament(participants, auto_advance = TRUE)
}
\arguments{
\item{participants}{Character vector of participant names, or a data.frame
with a \code{name} column.}

\item{auto_advance}{Logical scalar. Stored as the runtime default for future
result-entry helpers.}
}
\value{
A tournament runtime object with no stages materialized yet.
}
\description{
Create an empty live tournament pipeline
}
\examples{
# Simple tournament with auto-advance
teams <- c("Lions", "Bears", "Eagles", "Wolves")
trn <- tournament(teams) |>
  round_robin("groups") |>
  single_elim("finals", take = top_n(2))

# Manual advance mode
trn_manual <- tournament(teams, auto_advance = FALSE) |>
  swiss("open", rounds = 3)
}
