% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bracket.R, R/group_stage_knockout.R,
%   R/round_robin.R, R/swiss.R, R/tournament_runtime.R
\name{set_result}
\alias{set_result}
\alias{set_result.bracket}
\alias{set_result.group_stage_knockout}
\alias{set_result.round_robin_bracket}
\alias{set_result.swiss_bracket}
\alias{set_result.tournament}
\title{Set match result by scores}
\usage{
set_result(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = FALSE
)

\method{set_result}{bracket}(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = FALSE
)

\method{set_result}{group_stage_knockout}(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = FALSE
)

\method{set_result}{round_robin_bracket}(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = FALSE
)

\method{set_result}{swiss_bracket}(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = FALSE
)

\method{set_result}{tournament}(
  bracket,
  match_id,
  score1,
  score2,
  stage_id = NULL,
  overwrite = FALSE,
  auto_advance = TRUE
)
}
\arguments{
\item{bracket}{A bracket object}

\item{match_id}{The ID of the match to update}

\item{score1}{Score for participant 1, or a numeric vector of game scores.}

\item{score2}{Score for participant 2, or a numeric vector of game scores.}

\item{stage_id}{Optional stage identifier used by multi-stage tournament
runtimes.}

\item{overwrite}{Logical; when \code{TRUE}, requests explicit result overwrite
handling where supported.}

\item{auto_advance}{Logical; when \code{TRUE} and supported by the bracket type,
automatically advances completed stages.}
}
\value{
Updated bracket object
}
\description{
Record the score for a match. The winner is determined by the higher score.
}
\keyword{internal}
