% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{bilinear_uniform}
\alias{bilinear_uniform}
\title{Bilinear Uniform Interpolator}
\usage{
bilinear_uniform(x, rows, cols, dx = 1, dy = 1, x0 = 0, y0 = 0)
}
\arguments{
\item{x}{Numeric vector of all grid elements}

\item{rows}{Integer representing the number of rows in the grid}

\item{cols}{Integer representing the number of columns in the grid}

\item{dx}{Numeric value representing the spacing between grid points in the x-direction, defaults to 1}

\item{dy}{Numeric value representing the spacing between grid points in the y-direction, defaults to 1}

\item{x0}{Numeric value representing the x-coordinate of the origin, defaults to 0}

\item{y0}{Numeric value representing the y-coordinate of the origin, defaults to 0}
}
\value{
An object of class \code{bilinear_uniform} with methods:
\itemize{
\item \code{interpolate(xi, yi)}: Evaluate the interpolator at point \verb{(xi, yi)}.
}
}
\description{
Constructs a bilinear uniform interpolator given a grid of data points.
}
\examples{
x <- seq(0, 1, length.out = 10)
interpolator <- bilinear_uniform(x, rows = 2, cols = 5)
xi <- 0.5
yi <- 0.5
interpolator$interpolate(xi, yi)
}
