% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_hurdle_top3_posthoc}
\alias{summarise_hurdle_top3_posthoc}
\title{Summarise top-3 Hurdle-NB models across control combos}
\usage{
summarise_hurdle_top3_posthoc(bma_per_combo, dir_csv)
}
\arguments{
\item{bma_per_combo}{Optional named list of BMA results by control
combination, where each element contains a component \code{$table}
with columns such as \code{elpd}, \code{elpd_se}, \code{weight},
\code{k}, \code{hs_tau0}, \code{hs_slab_scale}, \code{hs_slab_df},
etc.}

\item{dir_csv}{Character scalar; directory where BMA weight CSV files
\code{"bma_weights_specC_ctrl*.csv"} are stored if
\code{bma_per_combo} is \code{NULL} or empty.}
}
\value{
A data frame with up to three rows and columns:
\itemize{
\item \code{model}: constant string \code{"Hurdle-NB"}.
\item \code{config}: textual description of the specification.
\item \code{elpd}, \code{elpd_se}, \code{weight}:
selection metrics from the BMA table.
\item \code{k}, \code{hs_tau0}, \code{hs_slab_scale},
\code{hs_slab_df}, \code{combo}: numeric tuning parameters
and control-combo tag.
}
If no valid tables are found, a single-row data frame with \code{NA}
entries is returned.
}
\description{
Extracts and summarises the top three Hurdle-NB specifications (by
estimated ELPD) from BMA selection tables, either taken from an
in-memory list of results or read from CSV files on disk.
}
\details{
If \code{bma_per_combo} is provided and non-empty, the function uses
its \code{$table} components. Otherwise, it scans \code{dir_csv} for
BMA weight files matching the pattern
\code{"bma_weights_specC_ctrl*.csv"} and reads them.

All valid rows are combined, ordered by decreasing \code{elpd}, and
the top three models are retained. For each, a human-readable
configuration string summarising \code{k}, the horseshoe hyperparameters
and the control combo is constructed.
}
