% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolling-oos.R
\name{print_floor_smoketest}
\alias{print_floor_smoketest}
\title{Print summary of FLOOR smoke test (ELPD ranking invariance)}
\usage{
print_floor_smoketest(st)
}
\arguments{
\item{st}{A list returned by \code{\link{smoketest_floor_elpd_invariance}},
containing at least:
\itemize{
\item \code{same_order}: logical flag indicating whether the ELPD
ranking is identical for all \code{FLOOR} values.
\item \code{combined}: data frame or tibble with columns
\code{FLOOR}, \code{fit_id}, \code{elpd}, \code{elpd_se},
and \code{rank_elpd}, among others.
}}
}
\value{
Invisibly returns the input object \code{st}, so it can be
used in pipes if desired.
}
\description{
Nicely prints a summary of the FLOOR smoke test produced by
\code{\link{smoketest_floor_elpd_invariance}}, indicating whether
the ELPD-based ranking of models is invariant across different
\code{FLOOR} constants and listing the combined results.
}
\details{
The function uses \pkg{cli} to print a section header and an info
message stating whether the ELPD ranking is invariant across values
of \code{FLOOR}. It then arranges the combined table by \code{FLOOR}
and decreasing \code{elpd}, selects a subset of columns, and prints
it to the console.

This is a convenience/reporting helper and does not modify \code{st}.
}
\examples{
\donttest{
# 1. Define dummy data inside the example so it runs on CRAN checks
st_dummy <- list(
  same_order = TRUE,
  combined = data.frame(
    FLOOR     = rep(c(-1e6, -1e4), each = 2),
    fit_id    = rep(c("model_1", "model_2"), 2),
    elpd      = c(-100.1, -101.3, -100.1, -101.3),
    elpd_se   = c(1.2, 1.3, 1.2, 1.3),
    rank_elpd = c(1L, 2L, 1L, 2L)
  )
)

# 2. Run the function
print_floor_smoketest(st_dummy)
}

}
