% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer-entropy.R
\name{prewhiten_rate_glm}
\alias{prewhiten_rate_glm}
\title{Pre-whiten rate series with log-link Gaussian GLM}
\usage{
prewhiten_rate_glm(DT, yname)
}
\arguments{
\item{DT}{A \code{data.frame} or \code{data.table} containing the
rate variable and covariates. It must include at least:
\itemize{
\item The rate variable named by \code{yname}.
\item \code{t_norm}: normalized time index.
\item \code{Regime}, \code{EconCycle}, \code{PopDensity},
\code{Epidemics}, \code{Climate}, \code{War}.
}}

\item{yname}{Character scalar; name of the rate response column in
\code{DT}.}
}
\value{
A numeric vector of Pearson residuals (one per row in \code{DT}
used in the fit).
}
\description{
Fits a Gaussian GLM with log link to a rate variable (count/exposure)
without offset, applying a small lower bound to avoid zeros, and
returns Pearson residuals as a pre-whitened series.
}
\details{
The response \code{y} is first sanitized via
\code{y_safe <- pmax(y, 1e-8)} to avoid taking logs of zero. The
model is then fit with \code{glm(family = gaussian(link = "log"))}.
}
\examples{
\donttest{
if (interactive()) {
  n <- 100
  DT <- data.frame(
    t_norm = seq_len(n) / n,
    I_rate = rgamma(n, 2, 1),
    Regime = factor(sample(c("A","B"), n, TRUE)),
    EconCycle = rnorm(n), PopDensity = runif(n),
    Epidemics = rbinom(n, 1, 0.1), Climate = rnorm(n), War = rbinom(n, 1, 0.05)
  )
  r_I_rate <- prewhiten_rate_glm(DT, "I_rate")
  head(r_I_rate)
}
}
}
