% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.first_pvalue}
\alias{.first_pvalue}
\title{Extract a p-value from nested test objects}
\usage{
.first_pvalue(x)
}
\arguments{
\item{x}{An object potentially containing a p-value, such as:
\itemize{
\item A list with element \code{p.value}.
\item A list with nested elements like \code{LMh}, \code{LMFh},
\code{pt.mul}, \code{jb.mul}, \code{arch.mul}, \code{arch.uni}.
\item A numeric value that can be interpreted as a p-value.
}}
}
\value{
A numeric scalar with the first p-value found, or
\code{NA_real_} if no p-value can be extracted.
}
\description{
Attempts to extract a single p-value from a variety of test result
objects, including nested lists produced by functions in the
\pkg{vars} package and related diagnostics.
}
\details{
The function recursively explores nested list components and attempts
to find a scalar p-value. Special handling is included for structures
like \code{jb.mul$JB}. If nothing suitable is found, \code{NA_real_}
is returned.
}
\keyword{internal}
