% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{project}
\alias{project}
\title{Create a Project Metadata Object}
\usage{
project(
  title,
  year = format(Sys.Date(), "\%Y"),
  language = "en",
  type,
  author = NULL,
  publisher = NULL,
  identifier = NULL,
  description = NULL,
  subject = NULL,
  contributor = NULL,
  license = NULL,
  funding = NULL,
  version = NULL,
  ...
)
}
\arguments{
\item{title}{\code{\link[=character]{character(1)}}\cr project title.}

\item{year}{\code{\link[=character]{character(1)}}\cr publication year, defaults to
current year.}

\item{language}{\code{\link[=character]{character(1)}}\cr primary language, defaults to
"en".}

\item{type}{\code{\link[=character]{character(1)}}\cr resource type, one of "Dataset",
"Software", "Image", "Model", "Text", "Collection", "Other".}

\item{author}{\code{\link[=person]{person(.)}}\cr person or organization objects created
with \code{person()}.}

\item{publisher}{\code{\link[=character]{character(1)}}\cr name of the publishing
entity.}

\item{identifier}{\code{\link[=character]{character(1)}}\cr project identifier (e.g.,
DOI).}

\item{description}{\code{\link[=character]{character(1)}}\cr abstract or description.}

\item{subject}{\code{\link[=character]{character(.)}}\cr keywords or classification
codes.}

\item{contributor}{\code{\link[=person]{person(.)}}\cr additional contributors as person
objects.}

\item{license}{\code{\link[=character]{character(1)}}\cr license or rights statement.}

\item{funding}{\code{\link[=character]{character(.)}}\cr funding information.}

\item{version}{\code{\link[=character]{character(1)}}\cr version of the resource.}

\item{...}{additional metadata elements as name-value pairs.}
}
\value{
An object of class "project" with standardized metadata fields.
}
\description{
Create a Project Metadata Object
}
\examples{
myProj <- project(title = "example project",
                  author = c(person("Jane", "Smith", email = "jane@example.com",
                                    role = "aut",
                                    comment = c(ORCID = "0000-0001-2345-6789",
                                                affiliation = "University of Example",
                                                ROR = "https://ror.org/05gq02987")),
                             person("Robert", "Jones", role = c("aut", "cre"))),
                  publisher = "example consortium",
                  type = "Dataset",
                  identifier = "10.5281/zenodo.1234567",
                  description = "A comprehensive explanation",
                  subject = c("keyword", "subject"),
                  license = "CC-BY-4.0")
}
