% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtree.r
\name{gtree}
\alias{gtree}
\title{Function to compute basal area of a tree}
\usage{
gtree(x, metrics = TRUE)
}
\arguments{
\item{x}{is the object (i.e., vector or scalar) having tree diameter.
By default the function assumes that the unit of measurement of
this variable is cm.}

\item{metrics}{is a logic value, the default is to \code{TRUE}, thus the diameter
has to be expressed in cm, and the resulting basal area will be expressed
in m\eqn{^{2}}{^2}. If metrics is \code{FALSE}, the diameter has to be in inches
and the resulting basal area will be in ft\eqn{^{2}}{^2}.}
}
\value{
The value of basal area in m\eqn{^{2}}{^2} or in ft\eqn{^{2}}{^2},
depending on the units of measurement being defined.
}
\description{
The function computes the basal area of a tree (\eqn{g}),
which only depends on its diameter at breast-height (\eqn{d}).
The basal area of a tree is computed as
\deqn{g = \left(\frac{\pi}{k}\right) d^{2}}
where the constant \eqn{k} depends on whether the diameter
and the resulting basal area are in the units of
the metric or imperial system.
}
\examples{

#Using the function
 gtree(40)
 gtree(x=30)
gtree(x=11.81,metrics=FALSE)

}
\author{
Christian Salas-Eljatib
}
